﻿
/*
  ytp_setting.設定名 = 値
      初期化用の設定。設定が必要なら、ytp_init() の呼び出し前にセットの事。
      例、ytp_setting.onStateChange = function( nCode, sName ){ ... }
  
  ytp_step_setting.設定名 = 値
      API 使用時の、連続(リスト)再生の設定。
      これは、後から何度でも設定変更可能。
  
  ytp_init( element, id )
      使用準備。引数は省略可能。
      引数１つ目は、プレーヤーを置く所の要素(例えば、空のブロック要素)。
      引数２つ目 id は、プレーヤーに設定したい id 。
  
  ytp_play( arg1, flgCue )
      指定の動画の再生。
       arg1: (引数1)、object 又は string 又は number 
           object: { videoId: String, mediaContentUrl: String, 
               startSeconds: Number, endSeconds: Number, 
               suggestedQuality: String }
           string: videoId or url
           number: リスト(配列)の要素 index(番号)
       flgCue: (引数2)、boolean 、true なら頭出しで停止(再生開始せず)。
               false (または指定なし)なら再生開始する。
  
  ytp_playList( list, flgCue ) //＜＜リストは、動作不明、未試験＜＜
      リストの再生。
      list: リストの指定、リストは、object の配列、
              または videoId の配列、または videoId のカンマ区切り文字列。
      flgCue: 最初の動画の頭出しで停止(待機)なら true に。
  
  ytp_step( flag )
      リスト再生時に、進む、戻る。API使用時のみ可。
      flag: true または無指定なら進む。false なら戻る。
  
  ytp_play() の第１引数、ytp_playList の第１引数の配列の要素
      が object の場合の詳細、
    { 
      videoId: String, //動画の指定。英数と _- から成る 11文字。
      mediaContentUrl: String,  //動画の指定
          // "http://www.youtube.com/v/<VIDEO_ID>" ？
      startSeconds: Number, //
      endSeconds: Number, //
      suggestedQuality: String //画質
          //値は small, medium, large, hd720, hd1080, highres or default.
    }
  
*/
/*==============================================================
■ 設定 */

//▼ 初期設定
var ytp_setting = {
    // 以下は初期化関数 ytp_init() の呼び出し前に設定の事
    
      vol: 10 // volume(音量、0～100)の初期値
    
    , flgNoAPI: false
        // YouTube のスクリプト API を使用しない。
        // ＝ プレーヤー要素の src に、直接、動画の URL を指定し、
        //    Player を、スクリプトから制御しない。
        // このファイルがローカルにある時、 YouTube の API は使えないので、
        //   true に切り替える。
    , flgSwf: false // iframe でなく、swf(object,embet要素)を使用する。
    , flgSwf2: false // swf の時、AS3 を指定しない
    
    //通知用関数の指定(API使用時)
    , onStateChange: null //引数１つ目は状態を示す数値、２つ目は文字列で。
        // 0: "ENDED", 1: "PLAYING", 2: "PAUSED", 3: "BUFFERING", 
        // 4: "CUED", -1: "unstarted"
    , onError: null //YouTube(API)のエラー
        //引数１つ目は、エラーメッセージ、２つ目にエラーコード。
    , onQualityChange: null //引数は、再生画質を示す文字列(small,medium,...)
        //以上は、YouTube(API)からのイベント。
    
    , onPlayerReady: null // プレーヤーの使用可能の通知。
        // エラーの場合は引数に エラー object。
    , onListStep: null //引数に配列番号(index)
        //リストの次の再生開始時に通知。
    , onMsg: null //引数は、メッセージ //onMsgOccur, onIncident
        // エラーなどを通知。
    
    , ptnVideoId: /^[\w-]{11}$/
        // videoId の判断のための正規表現
    , ptnUrl: /(http.?:)?[/]{2}\w+[/]/
    
    , iLimitList: 50 // flgNoAPI の時のリストの長さの最大数(制限)。
        // API を使えない時、リストは、URL のクエリの中に入れるので。
    , flgNoAnonList: false //
        // 連続(リスト)再生で、リスト再生でない場合も、戻るが出来る様に
        // する為の仮のリストを作らないようにさせるなら、true に。
    
    , flgNoList: false // API 使用時、連続(リスト)再生を行わないなら true に。
        // ( 独自のリスト操作をするなら、これを true にして、
        //   onStateChange で、0(ENDED)の時、ytp_play() を呼ぶ。)
    
    , width:  "640" //プレーヤーのサイズ
    , height: "390" //  〃 
    , init_vid: "" // video_id、初期の動画指定
}

if( ! ytp_setting.flgNoAPI && location.protocol=="file:" )
    ytp_setting.flgNoAPI = true
    // ローカルにある時は、 YouTube の API は使えないので。

//if( ! ytp_setting.flgSwf && $is.HTA ) ytp_setting.flgSwf = true//＜？
    // HTA の時は、swf を使用する( true に切り替える)。＜何故？

//▼ 連続(リスト)再生の設定
var ytp_step_setting = {
    running: false   // 自動進行(連続再生)なら true。
        // false なら、1 つ再生したら止まる。
  , reverse: false // 逆行なら true。
  , shuffle: false // ランダム進行なら true。(reverse より優先)
  , loop: false    // 繰返しなら true。(running でないなら一つを繰返す)
  
  //, once: true    // 自動進行(連続再生)なら false
      //running でなく、こちらをフラグとするか？//＜＜＜
}

//▼ 公開する変数・関数
// 関数
var ytp_init      // 初期化
var ytp_play      // 再生開始(リクエスト)
var ytp_playList  // リスト用再生開始(リクエスト)
        // API 使用時に、flgNoList なら使用できないが、非API では使用可。
  //以下は API 使用時のみ。
var ytp_step      // リスト送り(次へ|戻る)
var ytp_haveList  // リストがあるかどうか
var ytp_stopVideo // 再生停止(リクエスト)

var onYouTubePlayerReady, onYouTubeIframeAPIReady
    // youtube のスクリプトからのコールバック関数

// 変数
var ytplayer //プレーヤー(要素)

var ytp_currentList //現在のリスト
    // ytp_playList() へ渡された引数のリスト。但しそれが文字列の場合は、
    //   コンマで分けて配列にしたもの。API 使用時のみ。
//var ytp_currentIndex  //現在のリスト中の番号

/*==============================================================
■ 用意(初期化)する関数 */

function ytp_init( place, player_id ){//この関数はファイル末まで続く
  // place: プレーヤーを置く場所。
  //          iframe または object,embet 要素を置く親要素。
  // player_id: プレーヤー要素に指定したい id
  
  if( ytp_init.flgOVR ){//２度呼び防止、又は、API使用失敗時のやり直し？。未試＜
      //if( ytplayer ) return//API使用ではコールバックなければ、ytplayer に
        //代入されてないが、要素id が ytplayer だと、この判断は×。
      if( ! ytp_init.elmId ) return 
      ytplayer = document.getElementById( ytp_init.elmId )//最初の時の id
          // ytp_init.elmId に、player_id を入れ、コールバックで消している。
          // .elmId が残っていたら、API 使用の失敗
      ytp_init.elmId = undefined//３度目は出来なくする。
      if( ! ytplayer ) return//＜？
      ytp_setting.flgNoAPI = true // 非API とし、
      ytp_haveList = ytp_step = ytp_stopVideo = //先に定義した公開関数を消す
        onYouTubeIframeAPIReady = onYouTubePlayerReady = null
      if( oSet.onPlayerReady ) setTimeout( oSet.onPlayerReady, 0 )
      //以下で要素の作成はせず、非API 用に、関数などを再定義。
  }
  
  var oStep = ytp_step_setting
  var oSet  = ytp_setting//長いので、
  var flgNoAPI = oSet.flgNoAPI
  var flgSwf   = oSet.flgSwf
  var flgSwf2  = oSet.flgSwf2
  var ptnVideoId = oSet.ptnVideoId
  var ptnUrl   = oSet.ptnUrl
  
  var play_req//:function
  
  if( flgSwf )// object,embed 要素の作成用
    function createSwfElm( url ){
      if( ! url && url !="" ) url = ""//非API の場合、url は空。
      var str = //'<object id="'+player_id+'" width="640" height="390">\n'+
        '<param name="movie" value=\x22'+ url +'\x22></param>\n'
        +'<param name="allowFullScreen" value="true"></param>\n'
      //if( ! $is.IE ) str +=
        +'<embed src=\x22'+ url +'\x22 id=\x22'+ player_id +'\x22\n'
        +'  type="application/x-shockwave-flash"\n'
        +'  allowfullscreen="true" width='+ oSet.width 
        +'  height='+ oSet.height +' >\n'
        +'</embed>\n'
        //+'</object>\n'
      //var elm = document.createElement("object")
      //elm.innerHTML = str//IEで「未知の実行時エラー」の為、止め。
      //elm.id = player_id; elm.width = oSet.width; elm.height = oSet.height
      //place.appendChild(elm)
      str = '<object id=\x22'+ player_id +'\x22 width='
            + oSet.width +' height='+ oSet.height
            +' classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" '
            +'>\n'+ str +'</object>\n'
      place.innerHTML = str
    }
  
/*□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
■■ 非API の場合 */
  if( flgNoAPI ){// API を使えない場合の、IFRAME, SWF 両用
    /* 
    ▼ 再生をリクエストする関数 */
    ytp_play = function( arg1, flgCue ){
      var oArg, msg, type = typeof arg1
      if( arg1 ){
        if(type=="string"){ 
          if( ptnVideoId.test(arg1) ) oArg = { videoId: arg1 }
          else if( ptnUrl.test(arg1) ) oArg = { mediaContentUrl: arg1 }
          else{ msg = "ytp_play() 引数 string が不明。" }
        }
        else if(type=="object"){
          if( arg1.videoId || arg1.mediaContentUrl ) oArg = arg1;
          else{ msg = "ytp_play() 引数 object が不明。" }
        }
        else{ msg = "ytp_play() 引数 "+ type +" が不明。" }
      }
      else msg = "ytp_play() 引数が空。"
      if( msg && oSet.onMsg ) oSet.onMsg( msg )
      if( oArg ) play_req( oArg, flgCue )
    }
    
    ytp_playList = function( list, flgCue ){
      // リスト再生のリクエスト
      // list: オブジェクト(または文字列)の配列、またはカンマ区切り文字列
      //       null 等を渡された場合は、現在のリストを破棄する。
      
      if( flgSwf && flgSwf2 ){ 
          if(oSet.onMsg) oSet.onMsg("ytp_playList AS2 では不可？。")
          //return
      }
      var oArg, str =""
      var type = typeof list
      if( type=="string" )  list = list.split(/,/)
          // list が文字列の場合、一旦配列にしてから処理。
      var cntAvl =0//有効数
      if( $isArray(list) ){
        var msg ="", len= list.length
        if( len > oSet.iLimitList )//リクエストの長さ制限
            len = list.length = oSet.iLimitList
        var v, o, v_type
        for(var i=0; i<len; ++i){
          if( ! (v= list[i]) ){ msg += i+": 空, "; continue}
          o = null; v_type = typeof v;
          if( v_type=="string" );
          else if( v_type !="object" ){ msg += i+": "+v_type+" ?, "; continue }
          else{//v_type=="object" 
              o = v;  v = o.videoId
              if( !v ){ 
                if( o.mediaContentUrl ) msg += i+": url でなく videoId を, "
                else msg += i+": videoId が空, "
                continue // flgNoAPI でのリストは、videoId のみ。
              }else if( typeof v !="string" )
                { msg += i+": videoId "+(typeof v)+" ?, "; continue }
          }
          v = v.replace(/^\s+|\s+$/g,"")
          if( ! ptnVideoId.test(v) )// videoId かのテスト
              { msg += i+": videoId ?, "; continue }
          ++cntAvl
          if( ! oArg ) oArg = { videoId: v }//１つ目は oArg に。
          else str += (str ? ",":"")+ v
        }//for
        if( oArg ) for(var na in list) //2016/08/ 追加
              if( ! /^\d/.test(na) ) oArg[na] = list[na] //length は？
              // 配列object の他(数以外)のプロパティを利用して、
      }//if
      if( oArg ){ 
          if( msg && oSet.onMsg ) oSet.onMsg( "ytp_playList() "+ msg )
          setTimeout( function(){ 
                  play_req(oArg, flgCue, str) }, 0 )
      }
      else if( oSet.onMsg ) 
          oSet.onMsg( "ytp_playList() リスト無し?\n"+ msg )
    }
    
    play_req = function( oArg, flgCue, sList ){
      // flgCue: false なら再生開始(autoplay)、true なら頭出しで再生待ち
      // sList: ytp_playList() から来た時。
      var src
      if( oArg.videoId ) src = flgSwf ?
        "http://www.youtube.com/v/"+ oArg.videoId
        : "http://www.youtube.com/embed/"+ oArg.videoId
      else src = oArg.mediaContentUrl
      //if( !src ) return//testArgObj()で済み？
      
      src += "?rel=0" //は関連動画の表示をしない
        //+"&fs=1" //全画面ボタン
      if( flgSwf &&  ! flgSwf2 ) src += "&version=3"
      if( ! flgCue ) src += "&autoplay=1"
      if( oArg.startSeconds != null ) src += "&start="+ oArg.startSeconds
      if( oArg.endSeconds != null ) src += "&end="+ oArg.endSeconds
          //↑ end= は(パラメータに)無い、無効、？
      if( oStep.loop ) src += "&loop=1" //？＜＜
      
      //if( oArg.suggestedQuality ) src +=  //？＜//↓ 2016/08 テスト用
      if( oArg.hd ) src += "&hd=1" //動画の HD 版を//このパラメータはもう無い？
      if( oArg.fmt ) src += "&fmt="+ oArg.fmt //もう無い？＜＜＜
      
      if( sList ) src += "&playlist="+ sList
          // "&playlist=...", comma-separated list of video IDs
            // (supported players: AS3, HTML5)
      
      //if( ! flgSwf ) ytplayer.src = src
      //else ytplayer[ytplayer.tagName=="EMBED" ? "src": "Movie"] = src
      if( flgSwf && ytplayer.Movie !=null ) ytplayer.Movie = src//object
      else ytplayer.src = src //iframe, embet
    }
    
    ytp_stopVideo = function(){
        //if( flgSwf ){
        //    if( ytplayer.Movie !=null ) ytplayer.Movie = ""//object
        //    ytplayer.src = "" //embet
        //}
        //else ytplayer.src = ""//"about:blank" //iframe
        if( ytplayer.src ) ytplayer.src = ""
        if( ytplayer.Movie ) ytplayer.Movie = ""
    }
    
    /*==================================================================
    ▼ 要素の作成 */
    function init_noAPI_swf(){
      createSwfElm("")// SWF用要素(object,embet)の作成
      setTimeout( function(){ 
          //ytplayer = window[player_id] 
          ytplayer = document.getElementById(player_id)// object or embet ？
          if( ytplayer //&& ytplayer.？ //flash であれば＜＜？
            && oSet.onPlayerReady ) oSet.onPlayerReady()
      }, 0)
    }
    function init_noAPI_iframe(){
      // iframe 要素の作成、APIを使わない場合。
      var ifrm = document.createElement("iframe")
      ifrm.id = player_id
      ifrm.width = oSet.width;  ifrm.height = oSet.height
      place.appendChild( ifrm )
      ytplayer = ifrm
      if( oSet.onPlayerReady ) setTimeout( oSet.onPlayerReady, 0 )
    }
  }
  
/*□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
■■ API 使用時 */
  if( ! flgNoAPI ){// API 用関数、IFRAME, SWF(object,embet) 両用
    
    ytp_stopVideo = 
    function stopVideo(){
        if( ytplayer.getPlayerState() >0 ) ytplayer.stopVideo()
    }
    /*ytp_tglMute = function(){
        if( ytplayer.isMuted() ) ytplayer.unMute()
        else ytplayer.mute()
    }
    ytp_openW = function(){//他のウィンドーで開く
        var url = ytplayer.getVideoUrl()
        if( url ) window.open( url )
    }*/
    function initSetVol(){//初期時の音量調整用
      if( oSet.vol !=null ){
        //var vol = ytplayer.getVolume()
        //if( vol > oSet.vol ) 
        try{
          ytplayer.setVolume( oSet.vol )
        }catch(e){ if(oSet.onMsg) oSet.onMsg("setVolume でエラー。")  }
          //Volume: an integer between 0 and 100
      }
    }
    
    //▼ イベント(コールバック)用
    
    //function onStateChange_ytp( evt ){}
        //↑リスト使用か否かで別定義にする。
    var STATE_ytp = [ "ENDED", "PLAYING", "PAUSED", "BUFFERING", "CUED" ]
    STATE_ytp[-1] = "unstarted"
      // iframe の API には、YT.PlayerState ={ ENDED:0, PLAYING:1,... }
    
    function onQualityChange_ytp( evt ){
      var str = flgSwf ? evt: evt.data
      if( oSet.onQualityChange ) oSet.onQualityChange( str )
    }
    
    function onReady_ytp( evt ){//onReady は iframe, AS3 で。
      //evt.target.playVideo(); //ytplayer = evt.target
      if( oSet.onPlayerReady ) oSet.onPlayerReady()
      initSetVol()
      $addEventL_( window, "unload", function(){
          if( ytplayer && ytplayer.destroy ) ytplayer.destroy()
      })//動画のダウンロードを停止？
    }
    
    //function onError_ytp( evt ){ }
        //↑リスト使用か否かで別定義にする。
    var ErrMsgs_ytp = {
     // 2: "The request contains an invalid parameter value. For example, this error "
     // +"occurs if you specify a video ID that does not have 11 characters, or if the "
     // +"video ID contains invalid characters, such as exclamation points or asterisks."
     //,5: "The requested content cannot be played in an HTML5 player "
     // +"or another error related to the HTML5 player has occurred."//HTML5 ？＜＜
     //,100: "The video requested was not found. This error occurs when "
     // +"a video has been removed (for any reason) or has been marked as private."
     //,101: "The owner of the requested video does not allow it to be played in embedded players."
     //,150: "This error is the same as 101. It's just a 101 error in disguise!"
      2: "リクエストに無効なパラメータ(例えば不正な video ID )あり。"
     ,5: "HTML5 プレーヤーでは、再生できない。"
     ,100: "動画が見付からない。(削除されたり、非公開である事も含む。)"
     ,101: "動画のオーナーは埋め込みを許可していない。"
    }// onError にこのエラーコードが渡されるのだろうが、
     // 動画が見付からない時などに、onError が呼ばれてないのでは？＜＜＜
  }//End if
/*======================================================================
■  〃 、非リスト(非進行) */
  if( ! flgNoAPI && oSet.flgNoList ){
    // リストを使わない(自動進行しない)場合。
    ytp_play = function( arg1, flgCue ){
      //stopVideo()//再生中なら停止＜ //stopVideo is not defined
      ytp_stopVideo()
      var oArg, msg, type = typeof arg1
      if( arg1 ){
        if(type=="string"){ 
          if( ptnVideoId.test(arg1) ) oArg = { videoId: arg1 }
          else if( ptnUrl.test(arg1) ) oArg = { mediaContentUrl: arg1 }
          else{ msg = "ytp_play() 引数 string が不明。" }
        }
        else if(type=="object"){
          if( arg1.videoId || arg1.mediaContentUrl ) oArg = arg1;
          else{ msg = "ytp_play() 引数 object が不明。" }
        }
        else if(type=="number"){ msg = "ytp_play() リストは使ってない。" }
        else{ msg = "ytp_play() 引数 "+ type +" が不明。" }
      }
      else msg = "ytp_play() 引数が空。"
      if( msg && oSet.onMsg ) oSet.onMsg( msg )
      if( oArg ) play_req( oArg, flgCue )
    }
    //ytp_playList = undefined// リストは渡せない
    
    function onStateChange_ytp( evt ){
      var state = flgSwf ? evt: evt.data
      // unstarted (-1), ended (0), playing (1), paused (2), 
        // buffering (3), video cued (5).
      if( oSet.onStateChange ) 
        setTimeout( function(){
          oSet.onStateChange( state, STATE_ytp[state] )
        }, 0 )
    }
    
    function onError_ytp( evt ){
      if( oSet.onError ){ 
        var errcode = flgSwf ? evt: evt.data
        var msg = "Error "+ errcode +": "
            +( ErrMsgs_ytp[errcode] || "unknown" )
        oSet.onError( msg, errcode )
      }
    }
    
  }//if(flgNoList)
/*======================================================================
■  〃 、リスト使用時用 */
  if( ! flgNoAPI && ! oSet.flgNoList ){
  //function init_API_List()//変数を宣言したいので、if に
    
    function onStateChange_ytp( evt ){
      var state = flgSwf ? evt: evt.data
      // unstarted (-1), ended (0), playing (1), paused (2), 
        // buffering (3), video cued (5).
      if( oSet.onStateChange ) 
          oSet.onStateChange( state, STATE_ytp[state] )
      if( state===0 && (oStep.running || oStep.loop) )//＜？
          setTimeout("list_step()", 0)  //state==0: ENDED
          //自動進行しない場合も、loop なら再び、ytplayer.playVideo()
    }
    
    function onError_ytp( evt ){
      var flgContin
      if( aryCrrntList ){
        if( idxCrrnt==null ){
          if( aryAnon ){//リスト外を再生中
            if( aryAnon.length ){
              if( idxAnon !=null ){ aryAnon.splice(idxAnon,1)
                if( --idxAnon < 0 ) idxAnon =0  
              }
            }
            if( ! aryAnon.length ){ 
              clearAnonList()
              if( aryCrrntList && idxCrrnt !=null )
                { idxCrrnt_bk = idxCrrnt; idxCrrnt = null }
            }
          }//else?
        }
        else{//リスト再生中
          flgContin = true//次へ進む
          aryCrrntList[ idxCrrnt ] = null
          //ytp_currentList[ idxCrrnt ].error = true
        }
      }
      var errcode = flgSwf ? evt: evt.data
      var msg = "Error "+ errcode +": "
        +( ErrMsgs_ytp[errcode] || "unknown" )
      if( oSet.onError ) oSet.onError( msg, errcode )
      if( flgContin ) setTimeout("list_step()") //＜？
          //全てエラーで、loop だと、どうなる？！＜
    }
    
    /*
    ▼ ytp_play() 再生(リクエスト) */
    ytp_play = function( arg1, flgCue ){
      //stopVideo()//再生中なら停止＜
      ytp_stopVideo()
      var oArg, msg, type = typeof arg1, flgList
      if( arg1 ){//第１引数の検査
        if(type=="string"){
          if( ptnVideoId.test(arg1) ) oArg = { videoId: arg1 }
          else if( ptnUrl.test(arg1) ) oArg = { mediaContentUrl: arg1 }
          else{ msg = "ytp_play() 引数 string が不明。" }
        }
        else if(type=="object"){
          if( arg1.videoId || arg1.mediaContentUrl ) oArg = arg1;
          else{ msg = "ytp_play() 引数 object が不明。" }
        }
        else if(type=="number"){
          if( ! aryCrrntList ) msg = "ytp_play() 現在のリストがない。"
          else{
            if( arg1 < 0 ) arg1 = aryCrrntList.length - arg1//負は後ろから数え
            if( arg1 >= aryCrrntList.length || arg1 < 0 )
                msg = "ytp_play() 数-index-は、現在のリストの範囲外。"
            else if( ! (oArg= aryCrrntList[ arg1 ]) ){
                msg = "ytp_play() これは、再生できない。"
            }
            else{//有り
                idxCrrnt = arg1 //ここ(テスト関数)でセットは？＜＜
                if(idxCrrnt_bk !=null) idxCrrnt_bk = undefined
                if( aryAnon ) clearAnonList()//無名リスト(aryAnon)破棄
                flgList = true
            }
          }
        }
        else{ msg = "ytp_play() 引数 "+ type +" が不明。" }
      }
      else msg = "ytp_play() 引数が空。"
      if( msg && oSet.onMsg ) oSet.onMsg( msg )
      if( oArg ){
        if( flgList );//現在のリスト内
        else if( oSet.flgNoAnonList ){//無名リストを使わない＜＜
            if(aryAnon) clearAnonList() 
        }
        else{//新たな動画。無名リストに加える。
          if( ! aryAnon ) aryAnon = []
          aryAnon.push( oArg ); idxAnon = aryAnon.length-1
          if( aryCrrntList && idxCrrnt !=null )
              { idxCrrnt_bk = idxCrrnt; idxCrrnt = null }
              // リストある時は、aryCrrntList が存在するが、かつ
              // 現在の番号 idxCrrnt が null の時は、無名リストあり。
        }
        play_req( oArg, flgCue )
      }
    }
    
    //▼ リスト再生用変数等
    ytp_haveList = function(){
        return  aryCrrntList && aryCrrntList.length ? true: false
    }
    var aryCrrntList //要素は、object、渡されたリストのコピーだが、
        // その内無効な要素は、undefined にしてある。
    var aryLiIdxShuf, aryLiIdxShufBk, aryLiIdxShufFw //シャッフル再生用配列
        // 各要素は、aryCrrntList の内、有効要素の index
        // 視聴済みは、aryLiIdxShuf から削除し、aryLiIdxShufBk へ入れる。
        // aryLiIdxShuf へ戻った時、その要素は、aryLiIdxShufFw へ入れる。
    var idxCrrnt, idxCrrnt_bk // aryCrrntList 配列中の現在の位置(index)。
        // 一時的にリストから離れる時は、idxCrrnt_bk に、idxCrrnt の値を入れ、
        //   idxCrrnt を null にする。
    var aryAnon, idxAnon
        // リスト外のリスト。
    function clearAnonList(){
        aryAnon = null;  idxAnon = undefined
    }
    function clearCrrntList(){
        ytp_currentList = null
        aryCrrntList = null  // リストの破棄
        idxCrrnt = idxCrrnt_bk = undefined 
        aryLiIdxShuf = aryLiIdxShufBk = aryLiIdxShufFw = null
    }
    /*
    ▼ ytp_playList() リスト再生 */
    ytp_playList = function( list, flgCue ){
      // list: オブジェクト(または文字列)の配列、またはカンマ区切り文字列
      //       null 等を渡された場合は、現在のリストを破棄する。
      
      //stopVideo()//再生中なら停止＜
      ytp_stopVideo()
      if( aryAnon ){ clearAnonList() }// aryAnon の破棄
      if( ! list ){//現在のリストを破棄する。
          var msg
          if( aryCrrntList )
            { clearCrrntList(); msg = "現在のリストを破棄した。" }
          else msg = "引数にリストなし。"
          if(oSet.onMsg) oSet.onMsg("ytp_playList() "+ msg ) 
          return
      }
      function calloff(){//取り止め時、return 前に呼ぶ。
          clearCrrntList() //現在のリストを破棄
      }
      // 現在のリストの作成
      var aryList = [], aryIdx = []
      var type = typeof list
      if( type=="string" ) list = list.split(/,/)
          // list が文字列の場合、一旦配列にしてから処理。
      var cntAvl =0//有効数
      if( $isArray(list) ){
        var msg ="", len= list.length
        var v, o, v_type, flgUrl, flgOut
        for(var i=0; i<len; ++i){
          if( ! (v= list[i]) ){ msg += i+": 空, "; continue }
          o = null; v_type = typeof v; flgUrl= flgOut= false
          if( v_type=="string" );
          else if( v_type !="object" ){ msg += i+": "+v_type+" ?, "; continue }
          else{//v_type=="object" 
              o = v;  v = o.videoId
              if( !v ){ 
                if( v= o.mediaContentUrl ) flgUrl = true;
                else{ msg += i+": videoId が空, "; continue }
              }
              else if( typeof v !="string" )
                { msg += i+": videoId "+(typeof v)+" ?, "; continue}
          }
          // videoId かのテスト
          v = v.replace(/^\s+|\s+$/g,"")
          if( !o ){//要素の値が"string"の場合
              if( ptnVideoId.test(v) ) o = { videoId: v }
              else if( ptnUrl.test(v) ) o = { mediaContentUrl: v }
              else flgOut = true
          }
          else if( flgUrl ){ if( ! ptnUrl.test(v) ) flgOut = true }
          else if( ! ptnVideoId.test(v) ) flgOut = true
          if( flgOut )
              { msg += i+": "+(flgUrl ? "url":"videoId")+" ?, "; continue } 
          // リストへの追加
          ++cntAvl
          aryList[i] = o //aryCrrntList[i] = o
          aryIdx.push(i) //aryLiIdxShuf.push(i)
        }
        if( ! cntAvl || len != cntAvl ){//配列 list 中に無効な要素あり
          if( msg ) msg = msg.replace(/,\s*$/,"")
          if( ! len ) msg = "ytp_playList()、引数リストが空。"
          else if( ! cntAvl ) msg = "ytp_playList()、引数リストに"
              +"有効なものがない、\n"+ msg
          else msg = "ytp_playList()、引数リスト中に無効要素あり、\n"+ msg
          if( oSet.onMsg ) oSet.onMsg(msg)
          if( ! len ||  ! cntAvl ){ calloff(); return }
        }
      }else{// list が配列でない場合。
        if( oSet.onMsg ) oSet.onMsg("ytp_playList()、引数が "+ type )
        calloff(); return 
      }
      if( ! cntAvl ){//( ! aryList.length)でも //return済み？、無い筈？
        calloff()
        if( oSet.onMsg ) oSet.onMsg("ytp_playList() リスト無し?")
      }
      //現在のリストの作成
      aryCrrntList = aryList
      aryLiIdxShuf = aryIdx //shuffle 用
      ytp_currentList = list//引数に渡されたもの
      idxCrrnt = idxCrrnt_bk = undefined //; ytp_currentIndex = undefined
      aryLiIdxShuf_back =[], aryLiIdxShufFw =[]
          // shuffle 用の配列も予め作って置く。
      var idx //最初の再生番号
      if( oStep.shuffle ) idx = getIdx_Shuffle()
      else idx = getIdx_step()// 0 or last
      var oArg = aryCrrntList[ idx ]//;if(!oArg)？はない筈
      idxCrrnt = idx//; ytp_currentIndex = idx
      // play_req() の呼び出し
      if( oSet.onListStep ) oSet.onListStep( idx )//再生番号の通知
      setTimeout( function(){ play_req( oArg, flgCue ) }, 0 )
    }//End: ytp_playList()
    /*
    ▼ ytp_step() 進行用関数 */
    ytp_step = function( flgDir ){
      // flgDir: 方向指示 戻る/次へ
      if( flgDir===false ) flgDir = -1
      //else if( ! flgDir ) flgDir = 1
      else flgDir = 1
      if( aryAnon ){//リスト外リスト
          var ilast = aryAnon.length-1
          if( idxAnon==null ) idxAnon = ilast
          var idx = idxAnon + flgDir 
          var oArg
          if( -1< idx && idx< aryAnon.length ){//リスト外の中なら
              idxAnon = idx
              oArg = aryAnon[ idx ]
              //if( oSet.onListStep ) oSet.onListStep(？)
              if(oArg) play_req( oArg, flgCue )
              else if(oSet.onMsg) oSet.onMsg("ytp_step()、？")
              return//←！
          }
          //リスト外の範囲を出たら、リスト外リストは破棄。
          clearAnonList()
          if( aryCrrntList ){
            idxCrrnt = idxCrrnt_bk; idxCrrnt_bk = undefined
            if( idx< 0 ){//最後に居た所を再び
                oArg = aryCrrntList[ idxCrrnt ]
                if( oSet.onListStep ) oSet.onListStep(idxCrrnt)
                if(oArg) play_req( oArg, flgCue )
                return//←！
            }
            //else list_step( flgDir )//× //最後に居た所から進む
          }
          //else return//×
      }
      //if( aryCrrntList )//×
      list_step( flgDir )//リストの有無の確認は list_step() で。
    }
    
    function list_step( flgDir ){//リスト再生時の進行
      // 引数なしは、onStateChange:ENDED or onError から
      // 引数(flgDir)ありは、外部から。ytp_step()経由。
      // flgDir: 方向指示、戻る:-1 / 次へ:+1
      if( ! flgDir && ! oStep.running ){ 
          if( oStep.loop )//同じを繰返し
            setTimeout( function(){ ytplayer.playVideo() }, 0 )
          return
      }
      if( ! aryCrrntList || ! aryCrrntList.length ){ 
          if( oSet.onMsg ) oSet.onMsg("list_step()、リストが無いか空。"); 
          return 
      }
      if( idxCrrnt==null ){//リスト外の一時的再生中
          if( ! flgDir ) return//
          if( idxCrrnt_bk !=null ) idxCrrnt = idxCrrnt_bk
          else idxCrrnt = aryCrrntList.length -1
      }
      var nxt
      if( oStep.shuffle ) nxt = getIdx_Shuffle( flgDir )
      else nxt = getIdx_step( flgDir )//有効な次番を見つける
      if( nxt==null ){// idxCrrnt は変更せず。
        if( oSet.onMsg ){ 
          if( nxt===undefined ) oSet.onMsg("list_step()、次が見出せない。")
          else oSet.onMsg("list_step()、リスト終端。")
          // onStateChange:ENDED からなら、リスト終端
        }
      }else{
        idxCrrnt = nxt
        if( oSet.onListStep ) oSet.onListStep( nxt )//(nxt, oArg.videoId)
        var oArg = aryCrrntList[ nxt ]
        if( oArg ) setTimeout( function(){ play_req( oArg, flgCue ) }, 0 )
        //else//無い筈
      }
    }
    /* 
    ▼ リスト進行(ステップ)補助 */
        // ! aryCrrntList || ! aryCrrntList.length は排除済みである事
    function getIdx_step( flgDir ){
        // 次の(有効な)演目番号を見つける
        // 引数は外部指示(正負で方向指示)。
        // 戻り値は index か null
        var flgRev = flgDir ? (flgDir< 0): oStep.reverse
        var flgOvr = flgDir ? true: oStep.loop //末端で止まらない
        var iLast = aryCrrntList.length-1
        var idx = idxCrrnt==null ? (flgRev ? iLast: 0)//新規時は未定義で判断＜？
                :(flgRev ? idxCrrnt-1: idxCrrnt+1)
        var cnt = 0, len = aryCrrntList.length
        while( ! aryCrrntList[idx] ){
            if( ++cnt >= len ){ idx = undefined; break }//全て偽？
            flgRev ? 
              ( idx<=0 ? (flgOvr ? idx=iLast: idx=null): --idx )
              :( idx>=iLast ? (flgOvr ? idx = 0: idx=null): ++idx )
            if( idx==null ) break
        }
        //if( idx !=null ) idxCrrnt = idx //としてしまうか？
        return idx//number or null //null ならリスト終り
    }
    function getIdx_Shuffle( flgDir ){
        // シャッフル時の次の演目番号を返す。
        if( ! aryLiIdxShuf ){//後から Shuffle に変更//←ここは無い様変更済み
            aryLiIdxShuf =[], aryLiIdxShuf_back =[], aryLiIdxShufFw =[]
            for(var i=0,len=aryCrrntList.length; i<len; ++i)
                if(aryCrrntList[i]) aryLiIdxShuf.push(aryCrrntList[i])
        }
        else if( ! aryLiIdxShuf.length ){//再作成
            if( aryLiIdxShuf && flgDir==null ) return null//リスト終り
            aryLiIdxShuf = aryLiIdxShufBk
            //for(var i=0, len= aryCrrntList.length; i<len; ++i) 
            //    if( aryCrrntList[i] ) aryLiIdxShuf.push(i)
            aryLiIdxShufBk = []//, aryLiIdxShufFw = []
        }
        var idx
        if( ! flgDir && aryLiIdxShufFw.length ) flgDir =1//進むに残あり
        if( flgDir ){//進行指示あり
          if( flgDir < 0 ){//戻る
            if( aryLiIdxShufBk.length ){
                aryLiIdxShufFw.push( idx= aryLiIdxShufBk.pop() )
                return idx
            }
            else return getIdx_step(-1)
          }else if( aryLiIdxShufFw.length ){//進む
              aryLiIdxShufBk.push( idx= aryLiIdxShufFw.pop() )
              return idx
          }//else//残なしで進むは、通常のランダム進行、下へ
        }
        var i = $rnd(1, aryLiIdxShuf.length)
        var idx = aryLiIdxShuf[i]
        aryLiIdxShuf.splice(i,1)//再生済みとして取り除き、
        aryLiIdxShufBk.push(idx)//再生済みの配列に追加
        return idx
    }
  }//End if(リスト使用)
/*======================================================================
■  〃 、SWF */
  //if( ! flgNoAPI && flgSwf )
  function init_API_swf(){
    // SWF(object,embet)使用時
    
    play_req = function( oArg, flgCue ){
      //if( ! ytplayer ){ tglPlay_ytp(oArg, flgCue); return }
        //↑ onYouTubePlayerReady が、SWF側から呼び出されなかった場合。
      //if( ! (oArg= testArgObj(oArg)) ) return
      var startSeconds = oArg.startSeconds
      if( startSeconds != null ){
        startSeconds = Number( startSeconds )
        if( isNaN(startSeconds) ) startSeconds = undefined
      }
      var suggestedQuality = oArg.suggestedQuality//代入忘れ？、2016/08 修正
        // 再生画質？、string // ytplayer.setPlaybackQuality() で指定できる？
        // small, medium, large, hd720, hd1080, highres or default. 
      if( oArg.videoId ){
        if( flgCue ) ytplayer.cueVideoById( 
          oArg.videoId, startSeconds, suggestedQuality )
        else ytplayer.loadVideoById( 
          oArg.videoId, startSeconds, suggestedQuality )
      }
      else if( oArg.mediaContentUrl ){
        if( flgCue ) ytplayer.cueVideoByUrl( 
          oArg.mediaContentUrl, startSeconds, suggestedQuality )
        else ytplayer.loadVideoByUrl( 
          oArg.mediaContentUrl, startSeconds, suggestedQuality )
      }
    }
    
    // SWF からの初期時のコールバック
    onYouTubePlayerReady = function( playerid ){
      // playerid: 上 url の &playerapiid= に入れた値？
      //ytplayer = document.getElementById(playerid)//
      ytplayer = document.getElementById(player_id)
      //ytplayer = window[player_id] 
      ytp_init.elmId = undefined//成功のフラグ代わりに
      
      ytplayer.addEventListener("onReady", 
        (flgSwf2 ? "onReady_ytp": onReady_ytp) )//AS3 のみ？
      ytplayer.addEventListener("onStateChange", 
        (flgSwf2 ? "onStateChange_ytp": onStateChange_ytp) )
      ytplayer.addEventListener("onError", 
        (flgSwf2 ? "onError_ytp": onError_ytp) )
      ytplayer.addEventListener("onPlaybackQualityChange", 
        (flgSwf2 ? "onQualityChange_ytp": onQualityChange_ytp) )
        //.addEventListener(event:String, listener:String):Void
        //.addEventListener(event:String, listener:Function):Void, AS3 と
      if( flgSwf2 ){ 
        if( oSet.onPlayerReady ) 
          setTimeout(function(){ oSet.onPlayerReady() }, 0)
        initSetVol()
      }
    }
    
    // object,embed 要素の作成
    var url = "http://www.youtube.com/apiplayer?enablejsapi=1"
        //+"&playerapiid="+ player_id //不要？
        +(flgSwf2 ? "": "&version=3")
    if( oSet.init_vid ) url += "&video_id="+ oSet.init_vid
    createSwfElm( url )
  }//End func
/*======================================================================
■  〃 、IFrame */
  function init_API_iframe(){
    // IFRAME の API(youtubeのスクリプト)使用時
    
    play_req = function( oArg, flgCue ){
      //if( ! ytplayer ){ tglPlay_ytp(oArg, flgCue); return }
      //if( ! (oArg= testArgObj(oArg)) ) return
      if( oArg.startSeconds != null ){
        oArg.startSeconds = Number( oArg.startSeconds )
        if( isNaN(oArg.startSeconds) ) oArg.startSeconds = undefined
      }
      if( oArg.endSeconds != null ){
        oArg.endSeconds = Number( oArg.endSeconds )
        if( isNaN(oArg.endSeconds) ) oArg.endSeconds = undefined
      } 
      if( oArg.videoId ){
        if( flgCue ) ytplayer.cueVideoById( oArg )
        else ytplayer.loadVideoById( oArg )
      }
      else if( oArg.mediaContentUrl ){
        if( flgCue ) ytplayer.cueVideoByUrl( oArg )
        else ytplayer.loadVideoByUrl( oArg )
      }
        //.loadVideoById( videoId, startSeconds, suggestedQuality )
        //.cueVideoById( videoId, startSeconds, suggestedQuality )
    }
    
    
    // 要素の作成
    var elm = place.appendChild( document.createElement("span") )
    elm.id = player_id //これは、iframe に置き換えられる。
    elm.innerHTML ="この表示が消えないなら、<br>"
    	+ "　 API 付きのプレーヤーの使用は、失敗。"
    
    // YouTube API からの初期時のコールバック
    onYouTubeIframeAPIReady = function(){
      try{
        ytplayer = new YT.Player( player_id, {
          //height: '',//default 390
          //width: '',//default 640
          videoId: oSet.init_vid ? oSet.init_vid: "",
          playerVars: {
            //  autoplay: 0 //初期値 0
            //, controls: 0
            //, wmode: 'transparent'//z-index
            rel: 0 //？  //fs: 
            , enablejsapi: 1
            //, iv_load_policy: 3 //？、アノテーションの非表示
          }
          , events: {
              onReady:       onReady_ytp
            , onStateChange: onStateChange_ytp
            , onError:  onError_ytp
            , onPlaybackQualityChange: onQualityChange_ytp
            //, onApiChange: onApiChange_ytp
            //, onPlaybackRateChange: onRateChange_ytp//再生速度
          }
        })//new //iframe API では、YT というオブジェクトあり、
        
        if( ytplayer ) 
          ytp_init.elmId = undefined//成功のフラグ代わりに
        
      }catch(e){ 
        if( oSet.onPlayerReady ) oSet.onPlayerReady(e)//＜？
      }
    }
    // YouTube API の取り込み
    $addScript({ src: "https://www.youtube.com/iframe_api" })
        // .createElement("script")→ .body.appendChild()
  }//End func
/*======================================================================
■ 分岐、呼び出し */
  // 以下は主に要素作成用関数の呼び出し。それ以外は既に済み。
  if( ! ytp_init.flgOVR ){
      // 一度も呼ばれてないならば、要素を作成。
      ytp_init.flgOVR = true //一度呼ばれた事を記、
      
      if( ! place ) place = //置き場所の指定ないなら
        document.body.appendChild( document.createElement("div") )
      if( ! player_id ) player_id = "ytplayer"
      ytp_init.elmId = player_id //＜
      if( flgNoAPI ){
          if( flgSwf ) init_noAPI_swf()
          else init_noAPI_iframe()
      }
      else{
          if( flgSwf ) init_API_swf()
          else init_API_iframe()
          //oSet.flgNoList による分岐は、既に実行済み
      }
  }
}//END ytp_init()
//======================================================================
/*
<player>.playVideo():Void
<player>.pauseVideo():Void
<player>.stopVideo():Void
<player>.seekTo(seconds:Number, allowSeekAhead:Boolean):Void
<player>.clearVideo():Void //？

<player>.mute():Void
<player>.unMute():Void
<player>.isMuted():Boolean
<player>.setVolume(volume:Number):Void
<player>.getVolume():Number

<player>.setSize(width:Number, height:Number):Void //使うなとあり、
	//embet|object要素の height, width を変更せよ、と？

<player>.getPlayerState():Number
<player>.getCurrentTime():Number

<player>.getVideoBytesLoaded():Number
<player>.getVideoBytesTotal():Number
<player>.getVideoStartBytes():Number

<player>.getAvailableQualityLevels():Array
<player>.getPlaybackQuality():String
<player>.setPlaybackQuality(suggestedQuality:String):Void

<player>.getDuration():Number
	//動画のメタデータが読み込まれるまでは 0 を返す
<player>.getVideoUrl():String
<player>.getVideoEmbedCode():String

*/
